<?php

class CorrettoElatedButtonWidget extends CorrettoElatedWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_button_widget',
			esc_html__( 'Elated Button Widget', 'corretto' ),
			array( 'description' => esc_html__( 'Add button element to widget areas', 'corretto' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'corretto' ),
				'options' => array(
					'solid'   => esc_html__( 'Solid', 'corretto' ),
					'outline' => esc_html__( 'Outline', 'corretto' ),
					'simple'  => esc_html__( 'Simple', 'corretto' )
				)
			),
			array(
				'type'        => 'dropdown',
				'name'        => 'size',
				'title'       => esc_html__( 'Size', 'corretto' ),
				'options'     => array(
					'small'  => esc_html__( 'Small', 'corretto' ),
					'medium' => esc_html__( 'Medium', 'corretto' ),
					'large'  => esc_html__( 'Large', 'corretto' ),
					'huge'   => esc_html__( 'Huge', 'corretto' )
				),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'corretto' )
			),
			array(
				'type'    => 'textfield',
				'name'    => 'text',
				'title'   => esc_html__( 'Text', 'corretto' ),
				'default' => esc_html__( 'Button Text', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'link',
				'title' => esc_html__( 'Link', 'corretto' )
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'target',
				'title'   => esc_html__( 'Link Target', 'corretto' ),
				'options' => corretto_elated_get_link_target_array()
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'corretto' )
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'hover_color',
				'title' => esc_html__( 'Hover Color', 'corretto' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'background_color',
				'title'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'corretto' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_background_color',
				'title'       => esc_html__( 'Hover Background Color', 'corretto' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'corretto' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'border_color',
				'title'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'corretto' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_border_color',
				'title'       => esc_html__( 'Hover Border Color', 'corretto' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'corretto' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'margin',
				'title'       => esc_html__( 'Margin', 'corretto' ),
				'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'corretto' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$params = '';
		
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		// Filter out all empty params
		$instance = array_filter( $instance, function ( $array_value ) {
			return trim( $array_value ) != '';
		} );
		
		// Default values
		if ( ! isset( $instance['text'] ) ) {
			$instance['text'] = 'Button Text';
		}
		
		// Generate shortcode params
		foreach ( $instance as $key => $value ) {
			$params .= " $key='$value' ";
		}
		
		echo '<div class="widget eltdf-button-widget">';
			echo do_shortcode( "[eltdf_button $params]" ); // XSS OK
		echo '</div>';
	}
}