<?php

if ( ! function_exists( 'corretto_elated_get_title_types_meta_boxes' ) ) {
	function corretto_elated_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'corretto_elated_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'corretto' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'corretto_elated_map_title_meta' ) ) {
	function corretto_elated_map_title_meta() {
		$title_type_meta_boxes = corretto_elated_get_title_types_meta_boxes();
		
		$title_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'corretto_elated_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'corretto' ),
				'name'  => 'title_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'corretto' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'corretto' ),
				'parent'        => $title_meta_box,
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = corretto_elated_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'eltdf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'eltdf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'corretto' ),
						'description'   => esc_html__( 'Choose title type', 'corretto' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'corretto' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'corretto' ),
						'options'       => corretto_elated_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'corretto' ),
						'description' => esc_html__( 'Set a height for Title Area', 'corretto' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'corretto' ),
						'description' => esc_html__( 'Choose a background color for title area', 'corretto' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'corretto' ),
						'description' => esc_html__( 'Choose an Image for title area', 'corretto' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'corretto' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'corretto' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'corretto' ),
							'hide'                => esc_html__( 'Hide Image', 'corretto' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'corretto' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'corretto' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'corretto' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'corretto' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'corretto' )
						)
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'corretto' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'corretto' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'corretto' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'corretto' ),
							'window-top'    => esc_html__( 'From Window Top', 'corretto' )
						)
					)
				);

		corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_content_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Content Vertical Alignment', 'corretto' ),
						'description'   => esc_html__( 'Set title content vertical alignment', 'corretto' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							'' => esc_html__( 'Default', 'corretto' ),
							'top' => esc_html__( 'Top', 'corretto' ),
							'middle'    => esc_html__( 'Middle', 'corretto' ),
							'bottom'    => esc_html__( 'Bottom', 'corretto' )
						)
					)
				);
					
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_vertical_offset_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Title Vertical Offset', 'corretto' ),
						'description'   => esc_html__( 'Set title vertical offset relative to its current position', 'corretto' ),
						'parent'        => $show_title_area_meta_container,
						'args' 			=> array(
							'col_width' => '3',
							'suffix' => 'px'
						)
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'corretto' ),
						'options'       => corretto_elated_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'corretto' ),
						'description' => esc_html__( 'Choose a color for title text', 'corretto' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'corretto' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'corretto' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				corretto_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'corretto' ),
						'options'       => corretto_elated_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				corretto_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'corretto' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'corretto' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'corretto_elated_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_title_meta', 60 );
}