<?php 
	$price = get_post_meta(get_the_ID(), 'restaurant_menu_item_price', true);
	$label = get_post_meta(get_the_ID(), 'restaurant_menu_item_label', true);
	$description = get_post_meta(get_the_ID(), 'restaurant_menu_item_description', true);
?>
<li class="eltdf-rml-item clearfix">
	<?php if($show_featured_image === 'yes') : ?>
			<div class="eltdf-rml-item-image">
				<?php the_post_thumbnail('thumbnail'); ?>
			</div>
	<?php endif; ?>
	<div class="eltdf-rml-item-content">
		<div class="eltdf-rml-top-holder">
			<div class="eltdf-rml-title-holder">
				<h5 class="eltdf-rml-title">
					<?php esc_html(the_title()); ?>
				</h5>
			</div>
			<div class="eltdf-rml-line"></div>

			<?php if(!empty($price)) : ?>
				<div class="eltdf-rml-price-holder">
					<h5 class="eltdf-rml-price"><?php echo esc_html($price); ?></h5>
				</div>

			<?php endif; ?>
		</div>
		<div class="eltdf-rml-bottom-holder">
			<?php if(!empty($description)) : ?>
			<div class="eltdf-rml-description-holder">
				<?php echo esc_html($description); ?>
			</div>
			<?php endif; ?>
		</div>
	</div>

</li>