<?php
/*
Plugin Name: Corretto Restaurant
Description: Plugin that adds features to our theme
Author: Elated Themes
Version: 1.1
*/

include_once 'load.php';

add_action( 'after_setup_theme', array( CorrettoRestaurant\CPT\PostTypesRegister::getInstance(), 'register' ) );

if ( ! function_exists( 'corretto_restaurant_load_assets' ) ) {
	function corretto_restaurant_load_assets() {
		wp_enqueue_style( 'corretto-restaurant-style', plugins_url( '/assets/css/restaurant.min.css', __FILE__ ), array(), '' );
		
		if ( function_exists( 'corretto_elated_is_responsive_on' ) && corretto_elated_is_responsive_on() ) {
			wp_enqueue_style( 'corretto-restaurant-responsive-style', plugins_url( '/assets/css/restaurant-responsive.min.css', __FILE__ ), array(), '' );
		}
		
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'corretto-restaurant-script', plugins_url( '/assets/js/restaurant.min.js', __FILE__ ), array( 'jquery' ), '', true );
	}
	
	add_action( 'wp_enqueue_scripts', 'corretto_restaurant_load_assets' );
}

if ( ! function_exists( 'corretto_restaurant_style_dynamics_deps' ) ) {
	function corretto_restaurant_style_dynamics_deps( $deps ) {
		$style_dynamic_deps_array = array();
		$style_dynamic_deps_array[] = 'corretto-restaurant-style';
		
		if ( function_exists( 'corretto_elated_is_responsive_on' ) && corretto_elated_is_responsive_on() ) {
			$style_dynamic_deps_array[] = 'corretto-restaurant-responsive-style';
		}
		
		return array_merge( $deps, $style_dynamic_deps_array );
	}
	
	add_filter( 'corretto_elated_style_dynamic_deps', 'corretto_restaurant_style_dynamics_deps' );
}