<?php

if (!function_exists('corretto_elated_sidearea_options_map')) {
    function corretto_elated_sidearea_options_map() {

        corretto_elated_add_admin_page(
            array(
                'slug'  => '_side_area_page',
                'title' => esc_html__('Side Area', 'corretto'),
                'icon'  => 'fa fa-indent'
            )
        );

        $side_area_panel = corretto_elated_add_admin_panel(
            array(
                'title' => esc_html__('Side Area', 'corretto'),
                'name'  => 'side_area',
                'page'  => '_side_area_page'
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label'         => esc_html__('Side Area Type', 'corretto'),
                'description'   => esc_html__('Choose a type of Side Area', 'corretto'),
                'options'       => array(
                    'side-menu-slide-from-right'       => esc_html__('Slide from Right Over Content', 'corretto'),
                    'side-menu-slide-with-content'     => esc_html__('Slide from Right With Content', 'corretto'),
                    'side-area-uncovered-from-content' => esc_html__('Side Area Uncovered from Content', 'corretto'),
                ),
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'text',
                'name'          => 'side_area_width',
                'default_value' => '',
                'label'         => esc_html__('Side Area Width', 'corretto'),
                'description'   => esc_html__('Enter a width for Side Area (px or %). Default width: 405px.', 'corretto'),
                'args'          => array(
                    'col_width' => 3,
                )
            )
        );

        $side_area_width_container = corretto_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_width_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_type' => 'side-menu-slide-from-right',
                    )
                )
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'color',
                'name'          => 'side_area_content_overlay_color',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Color', 'corretto'),
                'description'   => esc_html__('Choose a background color for a content overlay', 'corretto'),
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'text',
                'name'          => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Transparency', 'corretto'),
                'description'   => esc_html__('Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)', 'corretto'),
                'args'          => array(
                    'col_width' => 3
                )
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_icon_source',
                'default_value' => 'icon_pack',
                'label'         => esc_html__('Select Side Area Icon Source', 'corretto'),
                'description'   => esc_html__('Choose whether you would like to use icons from an icon pack or SVG icons', 'corretto'),
                'options'       => corretto_elated_get_icon_sources_array()
            )
        );

        $side_area_icon_pack_container = corretto_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_icon_pack_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'icon_pack'
                    )
                )
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_icon_pack_container,
                'type'          => 'select',
                'name'          => 'side_area_icon_pack',
                'default_value' => 'linear_icon',
                'label'         => esc_html__('Side Area Icon Pack', 'corretto'),
                'description'   => esc_html__('Choose icon pack for Side Area icon', 'corretto'),
                'options'       => corretto_elated_icon_collections()->getIconCollectionsExclude(array('linea_icons', 'dripicons', 'simple_line_icons'))
            )
        );

        $side_area_svg_icons_container = corretto_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_svg_icons_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'svg_path'
                    )
                )
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_icon_svg_path',
                'label'       => esc_html__('Side Area Icon SVG Path', 'corretto'),
                'description' => esc_html__('Enter your Side Area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'corretto'),
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_close_icon_svg_path',
                'label'       => esc_html__('Side Area Close Icon SVG Path', 'corretto'),
                'description' => esc_html__('Enter your Side Area close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'corretto'),
            )
        );

        $side_area_icon_style_group = corretto_elated_add_admin_group(
            array(
                'parent'      => $side_area_panel,
                'name'        => 'side_area_icon_style_group',
                'title'       => esc_html__('Side Area Icon Style', 'corretto'),
                'description' => esc_html__('Define styles for Side Area icon', 'corretto')
            )
        );

        $side_area_icon_style_row1 = corretto_elated_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row1'
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_color',
                'label'  => esc_html__('Color', 'corretto')
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_hover_color',
                'label'  => esc_html__('Hover Color', 'corretto')
            )
        );

        $side_area_icon_style_row2 = corretto_elated_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row2',
                'next'   => true
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_color',
                'label'  => esc_html__('Close Icon Color', 'corretto')
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_hover_color',
                'label'  => esc_html__('Close Icon Hover Color', 'corretto')
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'color',
                'name'        => 'side_area_background_color',
                'label'       => esc_html__('Background Color', 'corretto'),
                'description' => esc_html__('Choose a background color for Side Area', 'corretto')
            )
        );

		corretto_elated_add_admin_field(
			array(
				'parent'      => $side_area_panel,
				'type'        => 'image',
				'name'        => 'side_area_background_image',
				'label'       => esc_html__('Background Image', 'corretto'),
				'description' => esc_html__('Choose a background image for Side Area', 'corretto')
			)
		);

        corretto_elated_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'text',
                'name'        => 'side_area_padding',
                'label'       => esc_html__('Padding', 'corretto'),
                'description' => esc_html__('Define padding for Side Area in format top right bottom left', 'corretto'),
                'args'        => array(
                    'col_width' => 3
                )
            )
        );

        corretto_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'selectblank',
                'name'          => 'side_area_aligment',
                'default_value' => '',
                'label'         => esc_html__('Text Alignment', 'corretto'),
                'description'   => esc_html__('Choose text alignment for side area', 'corretto'),
                'options'       => array(
                    ''       => esc_html__('Default', 'corretto'),
                    'left'   => esc_html__('Left', 'corretto'),
                    'center' => esc_html__('Center', 'corretto'),
                    'right'  => esc_html__('Right', 'corretto')
                )
            )
        );
    }

    add_action('corretto_elated_options_map', 'corretto_elated_sidearea_options_map', 6);
}