<?php

if ( ! function_exists( 'corretto_elated_logo_options_map' ) ) {
	function corretto_elated_logo_options_map() {
		
		corretto_elated_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'corretto' ),
				'icon'  => 'fa fa-coffee'
			)
		);
		
		$panel_logo = corretto_elated_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'corretto' )
			)
		);
		
		$hide_logo_container = corretto_elated_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'dependency' => array(
					'hide' => array(
						'hide_logo'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'corretto' ),
				'parent'        => $hide_logo_container
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo-dark.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'corretto' ),
				'parent'        => $hide_logo_container
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo-light.png",
				'label'         => esc_html__( 'Logo Image - Light', 'corretto' ),
				'parent'        => $hide_logo_container
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo-sticky.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'corretto' ),
				'parent'        => $hide_logo_container
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo-mobile.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'corretto' ),
				'parent'        => $hide_logo_container
			)
		);
	}
	
	add_action( 'corretto_elated_options_map', 'corretto_elated_logo_options_map', 2 );
}