<?php

if ( ! function_exists( 'corretto_elated_map_footer_meta' ) ) {
	function corretto_elated_map_footer_meta() {
		
		$footer_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'corretto_elated_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'corretto' ),
				'name'  => 'footer_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_footer_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Disable Footer for this Page', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'corretto' ),
				'options'       => corretto_elated_get_yes_no_select_array(),
				'parent'        => $footer_meta_box
			)
		);
		
		$show_footer_meta_container = corretto_elated_add_admin_container(
			array(
				'name'       => 'eltdf_show_footer_meta_container',
				'parent'     => $footer_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_disable_footer_meta' => 'yes'
					)
				)
			)
		);
		
			corretto_elated_create_meta_box_field(
				array(
					'name'          => 'eltdf_show_footer_top_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Top', 'corretto' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'corretto' ),
					'options'       => corretto_elated_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			
			corretto_elated_create_meta_box_field(
				array(
					'name'          => 'eltdf_show_footer_bottom_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Bottom', 'corretto' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'corretto' ),
					'options'       => corretto_elated_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);

		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_footer_in_grid_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Footer in Grid', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'corretto' ),
				'options'       => corretto_elated_get_yes_no_select_array(),
				'dependency' => array(
					'hide' => array(
						'eltdf_show_footer_top_meta' => array('', 'no'),
						'eltdf_show_footer_bottom_meta' => array('', 'no')
					)
				),
				'parent'        => $show_footer_meta_container
			)
		);

		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_uncovering_footer_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Uncovering Footer', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'corretto' ),
				'options'       => corretto_elated_get_yes_no_select_array(),
				'parent'        => $show_footer_meta_container,
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_footer_meta', 70 );
}