<?php

if(!function_exists('corretto_elated_design_styles')) {
    /**
     * Generates general custom styles
     */
    function corretto_elated_design_styles() {
	    $font_family = corretto_elated_options()->getOptionValue( 'google_fonts' );
	    if ( ! empty( $font_family ) && corretto_elated_is_font_option_valid( $font_family ) ) {
		    $font_family_selector = array(
			    'body'
		    );
		    echo corretto_elated_dynamic_css( $font_family_selector, array( 'font-family' => corretto_elated_get_font_option_val( $font_family ) ) );
	    }

		$first_main_color = corretto_elated_options()->getOptionValue('first_color');
        if(!empty($first_main_color)) {
            $color_selector = array(
				'a:hover',
				'blockquote',
				'h1 a:hover',
				'h2 a:hover',
				'h3 a:hover',
				'h4 a:hover',
				'h5 a:hover',
				'h6 a:hover',
				'p a:hover',
				'.eltdf-comment-holder .eltdf-comment-text .comment-edit-link',
				'.eltdf-comment-holder .eltdf-comment-text .comment-reply-link',
				'.eltdf-comment-holder .eltdf-comment-text .replay',
				'.eltdf-comment-holder .eltdf-comment-text #cancel-comment-reply-link',
				'.eltdf-owl-slider .owl-nav .owl-next:hover',
				'.eltdf-owl-slider .owl-nav .owl-prev:hover',
				'footer .widget a:hover',
				'footer .widget ul li a:hover',
				'footer .widget.widget_archive ul li a abbr:hover',
				'footer .widget.widget_categories ul li a abbr:hover',
				'footer .widget.widget_meta ul li a abbr:hover',
				'footer .widget.widget_nav_menu ul li a abbr:hover',
				'footer .widget.widget_pages ul li a abbr:hover',
				'footer .widget.widget_recent_entries ul li a abbr:hover',
				'footer .widget #wp-calendar tfoot a:hover',
				'footer .widget.widget_search .input-holder button:hover',
				'footer .widget.eltdf-recent-post-widget .eltdf-recent-posts .eltdf-rp-item a:hover .eltdf-rp-title',
				'footer .widget.widget_tag_cloud a:hover',
				'.eltdf-fullscreen-sidebar .widget a:hover',
				'.eltdf-fullscreen-sidebar .widget ul li a:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_archive ul li a abbr:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_categories ul li a abbr:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_meta ul li a abbr:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_nav_menu ul li a abbr:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_pages ul li a abbr:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_recent_entries ul li a abbr:hover',
				'.eltdf-fullscreen-sidebar .widget #wp-calendar tfoot a:hover',
				'.eltdf-fullscreen-sidebar .widget.widget_search .input-holder button:hover',
				'.eltdf-fullscreen-sidebar .widget.eltdf-recent-post-widget .eltdf-recent-posts .eltdf-rp-item a:hover .eltdf-rp-title',
				'.eltdf-fullscreen-sidebar .widget.widget_tag_cloud a:hover',
				'.eltdf-side-menu .widget a:hover',
				'.eltdf-side-menu .widget ul li a:hover',
				'.eltdf-side-menu .widget.widget_archive ul li a abbr:hover',
				'.eltdf-side-menu .widget.widget_categories ul li a abbr:hover',
				'.eltdf-side-menu .widget.widget_meta ul li a abbr:hover',
				'.eltdf-side-menu .widget.widget_nav_menu ul li a abbr:hover',
				'.eltdf-side-menu .widget.widget_pages ul li a abbr:hover',
				'.eltdf-side-menu .widget.widget_recent_entries ul li a abbr:hover',
				'.eltdf-side-menu .widget #wp-calendar tfoot a:hover',
				'.eltdf-side-menu .widget.widget_search .input-holder button:hover',
				'.eltdf-side-menu .widget.eltdf-recent-post-widget .eltdf-recent-posts .eltdf-rp-item a:hover .eltdf-rp-title',
				'.eltdf-side-menu .widget.widget_tag_cloud a:hover',
				'.wpb_widgetised_column .widget a:hover',
				'aside.eltdf-sidebar .widget a:hover',
				'.wpb_widgetised_column .widget ul li a:hover',
				'aside.eltdf-sidebar .widget ul li a:hover',
				'.wpb_widgetised_column .widget.widget_archive ul li a abbr:hover',
				'.wpb_widgetised_column .widget.widget_categories ul li a abbr:hover',
				'.wpb_widgetised_column .widget.widget_meta ul li a abbr:hover',
				'.wpb_widgetised_column .widget.widget_nav_menu ul li a abbr:hover',
				'.wpb_widgetised_column .widget.widget_pages ul li a abbr:hover',
				'.wpb_widgetised_column .widget.widget_recent_entries ul li a abbr:hover',
				'aside.eltdf-sidebar .widget.widget_archive ul li a abbr:hover',
				'aside.eltdf-sidebar .widget.widget_categories ul li a abbr:hover',
				'aside.eltdf-sidebar .widget.widget_meta ul li a abbr:hover',
				'aside.eltdf-sidebar .widget.widget_nav_menu ul li a abbr:hover',
				'aside.eltdf-sidebar .widget.widget_pages ul li a abbr:hover',
				'aside.eltdf-sidebar .widget.widget_recent_entries ul li a abbr:hover',
				'.wpb_widgetised_column .widget #wp-calendar tfoot a:hover',
				'aside.eltdf-sidebar .widget #wp-calendar tfoot a:hover',
				'.wpb_widgetised_column .widget.widget_search .input-holder button:hover',
				'aside.eltdf-sidebar .widget.widget_search .input-holder button:hover',
				'.wpb_widgetised_column .widget.eltdf-recent-post-widget .eltdf-recent-posts .eltdf-rp-item a:hover .eltdf-rp-title',
				'.wpb_widgetised_column .widget.widget_tag_cloud a:hover',
				'aside.eltdf-sidebar .widget.eltdf-recent-post-widget .eltdf-recent-posts .eltdf-rp-item a:hover .eltdf-rp-title',
				'aside.eltdf-sidebar .widget.widget_tag_cloud a:hover',
				'.widget.eltdf-author-info-widget .eltdf-aiw-text',
				'.widget.widget_eltdf_twitter_widget .eltdf-twitter-widget.eltdf-twitter-slider li .eltdf-tweet-text a',
				'.widget.widget_eltdf_twitter_widget .eltdf-twitter-widget.eltdf-twitter-slider li .eltdf-tweet-text span',
				'.widget.widget_eltdf_twitter_widget .eltdf-twitter-widget.eltdf-twitter-standard li .eltdf-tweet-text a:hover',
				'.widget.widget_eltdf_twitter_widget .eltdf-twitter-widget.eltdf-twitter-slider li .eltdf-twitter-icon i',
				'.widget_icl_lang_sel_widget .wpml-ls-legacy-dropdown .wpml-ls-item-toggle:hover',
				'.widget_icl_lang_sel_widget .wpml-ls-legacy-dropdown-click .wpml-ls-item-toggle:hover',
				'.eltdf-blog-holder article .eltdf-post-mark .eltdf-post-link-image',
				'.eltdf-blog-holder article .eltdf-post-mark .eltdf-post-quote-image',
				'.eltdf-blog-holder article.sticky .eltdf-post-title a',
				'.eltdf-blog-holder article .eltdf-post-info-top>div a:hover',
				'.eltdf-blog-holder article .eltdf-post-info-top>div .eltdf-post-info-author-link',
				'.eltdf-blog-holder article .eltdf-post-info-top .eltdf-post-info-category',
				'.eltdf-blog-holder article .eltdf-post-info-bottom .eltdf-post-info-bottom-left .eltdf-post-info-comments-holder .eltdf-post-info-comments:hover',
				'.eltdf-blog-holder article .eltdf-post-info-bottom .eltdf-post-info-bottom-right .eltdf-post-info-comments-holder .eltdf-post-info-comments:hover',
				'.eltdf-blog-holder article .eltdf-post-info-bottom .eltdf-post-info-bottom-left .eltdf-blog-like .eltdf-like.liked',
				'.eltdf-blog-holder article .eltdf-post-info-bottom .eltdf-post-info-bottom-left .eltdf-blog-like .eltdf-like:hover',
				'.eltdf-blog-holder article .eltdf-post-info-bottom .eltdf-post-info-bottom-right .eltdf-blog-like .eltdf-like.liked',
				'.eltdf-blog-holder article .eltdf-post-info-bottom .eltdf-post-info-bottom-right .eltdf-blog-like .eltdf-like:hover',
				'.eltdf-blog-holder article.format-link .eltdf-post-mark .eltdf-link-mark',
				'.eltdf-blog-holder article.format-quote .eltdf-post-mark .eltdf-quote-mark',
				'.eltdf-blog-holder article.format-quote .eltdf-quote-author',
				'.eltdf-blog-pagination ul li a:hover',
				'.eltdf-blog-pagination ul li a.eltdf-pag-active',
				'.eltdf-bl-standard-pagination ul li.eltdf-bl-pag-active a',
				'.eltdf-blog-holder.eltdf-blog-masonry article .eltdf-post-mark .eltdf-post-quote-image',
				'.eltdf-author-description .eltdf-author-description-text-holder .eltdf-author-name a:hover',
				'.eltdf-author-description .eltdf-author-description-text-holder .eltdf-author-social-icons a:hover',
				'.eltdf-blog-single-navigation .eltdf-blog-single-next:hover',
				'.eltdf-blog-single-navigation .eltdf-blog-single-prev:hover',
				'.eltdf-related-posts-holder .eltdf-related-post .eltdf-post-info .eltdf-post-info-author a',
				'.eltdf-related-posts-holder .eltdf-related-post .eltdf-post-info .eltdf-post-info-category a',
				'.eltdf-blog-list-holder .eltdf-bli-info>div a:hover',
				'.eltdf-header-vertical .eltdf-vertical-menu ul li a:hover',
				'.eltdf-header-vertical .eltdf-vertical-menu ul li.current-menu-ancestor>a',
				'.eltdf-header-vertical .eltdf-vertical-menu ul li.current-menu-item>a',
				'.eltdf-header-vertical .eltdf-vertical-menu ul li.current_page_item>a',
				'.eltdf-header-vertical .eltdf-vertical-menu ul li.eltdf-active-item>a',
				'.eltdf-header-vertical .eltdf-vertical-menu.eltdf-vertical-dropdown-float .second li a:hover',
				'.eltdf-header-vertical .eltdf-vertical-menu.eltdf-vertical-dropdown-float .second li.current-menu-ancestor>a',
				'.eltdf-header-vertical .eltdf-vertical-menu.eltdf-vertical-dropdown-float .second li.current-menu-item>a',
				'.eltdf-header-vertical .eltdf-vertical-menu.eltdf-vertical-dropdown-float .second li.current_page_item>a',
				'.eltdf-header-vertical .eltdf-vertical-menu.eltdf-vertical-dropdown-float .second li.eltdf-active-item>a',
				'.eltdf-mobile-header .eltdf-mobile-menu-opener.eltdf-mobile-menu-opened a',
				'.eltdf-mobile-header .eltdf-mobile-nav .eltdf-grid>ul>li.eltdf-active-item>a',
				'.eltdf-mobile-header .eltdf-mobile-nav .eltdf-grid>ul>li.eltdf-active-item>h6',
				'.eltdf-mobile-header .eltdf-mobile-nav ul li a:hover',
				'.eltdf-mobile-header .eltdf-mobile-nav ul li h6:hover',
				'.eltdf-mobile-header .eltdf-mobile-nav ul ul li.current-menu-ancestor>a',
				'.eltdf-mobile-header .eltdf-mobile-nav ul ul li.current-menu-ancestor>h6',
				'.eltdf-mobile-header .eltdf-mobile-nav ul ul li.current-menu-item>a',
				'.eltdf-mobile-header .eltdf-mobile-nav ul ul li.current-menu-item>h6',
				'.eltdf-search-page-holder article.sticky .eltdf-post-title a',
				'.eltdf-search-cover .eltdf-search-close:hover',
				'.eltdf-side-menu-button-opener.opened',
				'.eltdf-side-menu-button-opener:hover',
				'.eltdf-side-menu a.eltdf-close-side-menu:hover',
				'.eltdf-pl-filter-holder ul li.eltdf-pl-current span',
				'.eltdf-pl-filter-holder ul li:hover span',
				'.eltdf-pl-standard-pagination ul li.eltdf-pl-pag-active a',
				'.eltdf-portfolio-list-holder.eltdf-pl-gallery-overlay-zoom article .eltdf-pli-text .eltdf-pli-category-holder a:hover',
				'.eltdf-portfolio-list-holder.eltdf-pl-gallery-overlay article .eltdf-pli-text .eltdf-pli-category-holder a:hover',
				'.eltdf-testimonials-holder .eltdf-testimonial-quote-image',
				'.eltdf-banner-holder .eltdf-banner-link-text .eltdf-banner-link-hover span',
				'.eltdf-countdown .countdown-row .countdown-section .countdown-amount',
				'.eltdf-counter-holder .eltdf-counter',
				'.eltdf-item-showcase-holder .eltdf-is-item .eltdf-item-icon:hover',
				'.eltdf-social-share-holder.eltdf-list li a:hover',
				'.eltdf-social-share-holder.eltdf-dropdown .eltdf-social-share-dropdown-opener:hover',
				'.eltdf-tabs.eltdf-tabs-simple .eltdf-tabs-nav li.ui-state-active a',
				'.eltdf-tabs.eltdf-tabs-simple .eltdf-tabs-nav li.ui-state-hover a',
				'.eltdf-team-holder .eltdf-team-social-holder .eltdf-team-icon a:hover',
				'.eltdf-video-button-holder .eltdf-video-button-play',
				'.eltdf-twitter-list-holder .eltdf-twitter-icon',
				'.eltdf-twitter-list-holder .eltdf-tweet-text a:hover',
				'.eltdf-twitter-list-holder .eltdf-twitter-profile a:hover'
            );

            $woo_color_selector = array();
            if(corretto_elated_is_woocommerce_installed()) {
                $woo_color_selector = array(
					'.eltdf-pl-holder .eltdf-pli .eltdf-pli-rating',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-rating',
					'.eltdf-pls-holder .eltdf-pls-text .eltdf-pls-rating',
					'.eltdf-product-info .eltdf-pi-rating',
					'.eltdf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a.active:after',
					'.eltdf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a:before',
					'.woocommerce .star-rating',
					'.woocommerce-pagination .page-numbers li a.current',
					'.woocommerce-pagination .page-numbers li a:hover',
					'.woocommerce-pagination .page-numbers li span.current',
					'.woocommerce-pagination .page-numbers li span:hover',
					'.woocommerce-page .eltdf-content .eltdf-quantity-buttons .eltdf-quantity-minus:hover',
					'.woocommerce-page .eltdf-content .eltdf-quantity-buttons .eltdf-quantity-plus:hover',
					'div.woocommerce .eltdf-quantity-buttons .eltdf-quantity-minus:hover',
					'div.woocommerce .eltdf-quantity-buttons .eltdf-quantity-plus:hover',
					'.eltdf-woo-single-page .eltdf-single-product-summary .product_meta>span a:hover',
					'.eltdf-woo-single-page .woocommerce-tabs .star-rating',
					'.eltdf-woo-single-page .related.products .product .star-rating',
					'.eltdf-woo-single-page .upsells.products .product .star-rating',
					'.eltdf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a.active:after',
					'.eltdf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a:before',
					'.eltdf-shopping-cart-dropdown .eltdf-item-info-holder .eltdf-product-title a:hover',
					'.eltdf-shopping-cart-dropdown .eltdf-item-info-holder .remove:hover',
					'.widget.woocommerce.widget_layered_nav ul li.chosen a',
					'.widget.woocommerce.widget_product_tag_cloud .tagcloud a:hover'
                );
            }

            $color_selector = array_merge($color_selector, $woo_color_selector);

	        $color_important_selector = array(
				'.eltdf-btn.eltdf-btn-simple:not(.eltdf-btn-custom-hover-color):not(.eltdf-btn-underline):hover'
	        );

            $background_color_selector = array(
				'.eltdf-st-loader .pulse',
				'.eltdf-st-loader .double_pulse .double-bounce1',
				'.eltdf-st-loader .double_pulse .double-bounce2',
				'.eltdf-st-loader .cube',
				'.eltdf-st-loader .rotating_cubes .cube1',
				'.eltdf-st-loader .rotating_cubes .cube2',
				'.eltdf-st-loader .stripes>div',
				'.eltdf-st-loader .wave>div',
				'.eltdf-st-loader .two_rotating_circles .dot1',
				'.eltdf-st-loader .two_rotating_circles .dot2',
				'.eltdf-st-loader .five_rotating_circles .container1>div',
				'.eltdf-st-loader .five_rotating_circles .container2>div',
				'.eltdf-st-loader .five_rotating_circles .container3>div',
				'.eltdf-st-loader .atom .ball-1:before',
				'.eltdf-st-loader .atom .ball-2:before',
				'.eltdf-st-loader .atom .ball-3:before',
				'.eltdf-st-loader .atom .ball-4:before',
				'.eltdf-st-loader .clock .ball:before',
				'.eltdf-st-loader .mitosis .ball',
				'.eltdf-st-loader .lines .line1',
				'.eltdf-st-loader .lines .line2',
				'.eltdf-st-loader .lines .line3',
				'.eltdf-st-loader .lines .line4',
				'.eltdf-st-loader .fussion .ball',
				'.eltdf-st-loader .fussion .ball-1',
				'.eltdf-st-loader .fussion .ball-2',
				'.eltdf-st-loader .fussion .ball-3',
				'.eltdf-st-loader .fussion .ball-4',
				'.eltdf-st-loader .wave_circles .ball',
				'.eltdf-st-loader .pulse_circles .ball',
				'#submit_comment',
				'.post-password-form input[type=submit]',
				'input.wpcf7-form-control.wpcf7-submit',
				'#eltdf-back-to-top',
				'.eltdf-social-icons-group-widget.eltdf-square-icons .eltdf-social-icon-widget-holder:hover',
				'.eltdf-social-icons-group-widget.eltdf-square-icons.eltdf-light-skin .eltdf-social-icon-widget-holder:hover',
				'.eltdf-blog-holder article.format-audio .eltdf-blog-audio-holder .mejs-container .mejs-controls>.mejs-time-rail .mejs-time-total .mejs-time-current',
				'.eltdf-blog-holder article.format-audio .eltdf-blog-audio-holder .mejs-container .mejs-controls>a.mejs-horizontal-volume-slider .mejs-horizontal-volume-current',
				'.eltdf-blog-list-holder .eltdf-bli-image-holder .eltdf-post-info-date',
				'.eltdf-top-bar',
				'.eltdf-accordion-holder.eltdf-ac-boxed .eltdf-accordion-title.ui-state-active',
				'.eltdf-accordion-holder.eltdf-ac-boxed .eltdf-accordion-title.ui-state-hover',
				'.eltdf-btn.eltdf-btn-solid',
				'.eltdf-icon-shortcode.eltdf-circle .eltdf-icon-bckg-holder',
				'.eltdf-icon-shortcode.eltdf-dropcaps.eltdf-circle .eltdf-icon-bckg-holder',
				'.eltdf-icon-shortcode.eltdf-square .eltdf-icon-bckg-holder',
				'.eltdf-price-table .eltdf-pt-inner ul li.eltdf-pt-title-holder',
				'.eltdf-process-holder .eltdf-process-circle',
				'.eltdf-process-holder .eltdf-process-line',
				'.eltdf-progress-bar .eltdf-pb-content-holder .eltdf-pb-content',
				'.eltdf-tabs.eltdf-tabs-standard .eltdf-tabs-nav li.ui-state-active a',
				'.eltdf-tabs.eltdf-tabs-standard .eltdf-tabs-nav li.ui-state-hover a',
				'.eltdf-tabs.eltdf-tabs-boxed .eltdf-tabs-nav li.ui-state-active a',
				'.eltdf-tabs.eltdf-tabs-boxed .eltdf-tabs-nav li.ui-state-hover a',
				'.eltdf-tabs.eltdf-tabs-vertical .eltdf-tabs-nav li.ui-state-active a',
				'.eltdf-tabs.eltdf-tabs-vertical .eltdf-tabs-nav li.ui-state-hover a',
            );

            $woo_background_color_selector = array();
            if(corretto_elated_is_woocommerce_installed()) {
                $woo_background_color_selector = array(
					'.woocommerce-page .eltdf-content .wc-forward:not(.added_to_cart):not(.checkout-button)',
					'.woocommerce-page .eltdf-content a.added_to_cart',
					'.woocommerce-page .eltdf-content a.button',
					'.woocommerce-page .eltdf-content button[type=submit]:not(.eltdf-woo-search-widget-button)',
					'.woocommerce-page .eltdf-content input[type=submit]',
					'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button)',
					'div.woocommerce a.added_to_cart',
					'div.woocommerce a.button',
					'div.woocommerce button[type=submit]:not(.eltdf-woo-search-widget-button)',
					'div.woocommerce input[type=submit]',
					'.eltdf-woo-single-page .woocommerce-tabs ul.tabs>li.active',
					'.eltdf-woo-single-page .woocommerce-tabs ul.tabs>li:hover',
					'.eltdf-shopping-cart-dropdown .eltdf-cart-bottom .eltdf-view-cart',
					'.widget.woocommerce.widget_price_filter .price_slider_wrapper .ui-widget-content .ui-slider-range',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-add-to-cart.eltdf-default-skin .added_to_cart',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-add-to-cart.eltdf-default-skin .button',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-add-to-cart.eltdf-light-skin .added_to_cart:hover',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-add-to-cart.eltdf-light-skin .button:hover',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-add-to-cart.eltdf-dark-skin .added_to_cart:hover',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-add-to-cart.eltdf-dark-skin .button:hover',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-text-inner .eltdf-pli-add-to-cart.eltdf-default-skin .added_to_cart',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-text-inner .eltdf-pli-add-to-cart.eltdf-default-skin .button',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-text-inner .eltdf-pli-add-to-cart.eltdf-light-skin .added_to_cart:hover',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-text-inner .eltdf-pli-add-to-cart.eltdf-light-skin .button:hover',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-text-inner .eltdf-pli-add-to-cart.eltdf-dark-skin .added_to_cart:hover',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-text-inner .eltdf-pli-add-to-cart.eltdf-dark-skin .button:hover'
                );
            }

            $background_color_selector = array_merge($background_color_selector, $woo_background_color_selector);

            $border_color_selector = array(
				'.eltdf-st-loader .pulse_circles .ball',
				'#respond input:focus[type=text]',
				'#respond textarea:focus',
				'.eltdf-style-form textarea:focus',
				'.wpcf7-form-control.wpcf7-date:focus',
				'.wpcf7-form-control.wpcf7-number:focus',
				'.wpcf7-form-control.wpcf7-quiz:focus',
				'.wpcf7-form-control.wpcf7-select:focus',
				'.wpcf7-form-control.wpcf7-text:focus',
				'.wpcf7-form-control.wpcf7-textarea:focus',
				'input:focus[type=text]',
				'input:focus[type=email]',
				'input:focus[type=password]',
				'.eltdf-owl-slider+.eltdf-slider-thumbnail>.eltdf-slider-thumbnail-item.active img',
				'.widget.eltdf-author-info-widget',
            );

			if(corretto_elated_is_woocommerce_installed()) {
				$woo_border_color_selector = array(
					'.woocommerce .eltdf-onsale:before',
					'.woocommerce .eltdf-new-product:before',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-image-outer .eltdf-plc-image .eltdf-plc-onsale:before',
					'.eltdf-plc-holder .eltdf-plc-item .eltdf-plc-image-outer .eltdf-plc-image .eltdf-plc-new-product:before',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-image .eltdf-pli-onsale:before',
					'.eltdf-pl-holder .eltdf-pli-inner .eltdf-pli-image .eltdf-pli-new-product:before',
				);
			}
			$border_color_selector = array_merge($border_color_selector, $woo_border_color_selector);

            echo corretto_elated_dynamic_css($color_selector, array('color' => $first_main_color));
	        echo corretto_elated_dynamic_css($color_important_selector, array('color' => $first_main_color.'!important'));
	        echo corretto_elated_dynamic_css($background_color_selector, array('background-color' => $first_main_color));
	        echo corretto_elated_dynamic_css($border_color_selector, array('border-color' => $first_main_color));
        }
	
	    $page_background_color = corretto_elated_options()->getOptionValue( 'page_background_color' );
	    if ( ! empty( $page_background_color ) ) {
		    $background_color_selector = array(
			    'body',
			    '.eltdf-content'
		    );
		    echo corretto_elated_dynamic_css( $background_color_selector, array( 'background-color' => $page_background_color ) );
	    }
	
	    $selection_color = corretto_elated_options()->getOptionValue( 'selection_color' );
	    if ( ! empty( $selection_color ) ) {
		    echo corretto_elated_dynamic_css( '::selection', array( 'background' => $selection_color ) );
		    echo corretto_elated_dynamic_css( '::-moz-selection', array( 'background' => $selection_color ) );
	    }
	
	    $preload_background_styles = array();
	
	    if ( corretto_elated_options()->getOptionValue( 'preload_pattern_image' ) !== "" ) {
		    $preload_background_styles['background-image'] = 'url(' . corretto_elated_options()->getOptionValue( 'preload_pattern_image' ) . ') !important';
	    }
	
	    echo corretto_elated_dynamic_css( '.eltdf-preload-background', $preload_background_styles );
    }

    add_action('corretto_elated_style_dynamic', 'corretto_elated_design_styles');
}

if ( ! function_exists( 'corretto_elated_content_styles' ) ) {
	function corretto_elated_content_styles() {
		$content_style = array();

		$padding = corretto_elated_options()->getOptionValue( 'content_padding' );
		if ( $padding !== '' ) {
			$content_style['padding'] = $padding;
		}
		
		$content_selector = array(
			'.eltdf-content .eltdf-content-inner > .eltdf-full-width > .eltdf-full-width-inner',
		);
		
		echo corretto_elated_dynamic_css( $content_selector, $content_style );
		
		$content_style_in_grid = array();

		$padding_in_grid = corretto_elated_options()->getOptionValue( 'content_padding_in_grid' );
		if ( $padding_in_grid !== '' ) {
			$content_style_in_grid['padding'] = $padding_in_grid;
		}
		
		$content_selector_in_grid = array(
			'.eltdf-content .eltdf-content-inner > .eltdf-container > .eltdf-container-inner',
		);
		
		echo corretto_elated_dynamic_css( $content_selector_in_grid, $content_style_in_grid );

		$background_style = array();
		$background_image = corretto_elated_options()->getOptionValue('content_background_image');
		if ($background_image !== ''){
			$background_style['background-image'] = 'url('.esc_url($background_image).')';
		}

		echo corretto_elated_dynamic_css( '.eltdf-content', $background_style );
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_content_styles' );
}

if ( ! function_exists( 'corretto_elated_h1_styles' ) ) {
	function corretto_elated_h1_styles() {
		$margin_top    = corretto_elated_options()->getOptionValue( 'h1_margin_top' );
		$margin_bottom = corretto_elated_options()->getOptionValue( 'h1_margin_bottom' );
		
		$item_styles = corretto_elated_get_typography_styles( 'h1' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = corretto_elated_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = corretto_elated_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h1'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_h1_styles' );
}

if ( ! function_exists( 'corretto_elated_h2_styles' ) ) {
	function corretto_elated_h2_styles() {
		$margin_top    = corretto_elated_options()->getOptionValue( 'h2_margin_top' );
		$margin_bottom = corretto_elated_options()->getOptionValue( 'h2_margin_bottom' );
		
		$item_styles = corretto_elated_get_typography_styles( 'h2' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = corretto_elated_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = corretto_elated_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h2'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_h2_styles' );
}

if ( ! function_exists( 'corretto_elated_h3_styles' ) ) {
	function corretto_elated_h3_styles() {
		$margin_top    = corretto_elated_options()->getOptionValue( 'h3_margin_top' );
		$margin_bottom = corretto_elated_options()->getOptionValue( 'h3_margin_bottom' );
		
		$item_styles = corretto_elated_get_typography_styles( 'h3' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = corretto_elated_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = corretto_elated_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h3'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_h3_styles' );
}

if ( ! function_exists( 'corretto_elated_h4_styles' ) ) {
	function corretto_elated_h4_styles() {
		$margin_top    = corretto_elated_options()->getOptionValue( 'h4_margin_top' );
		$margin_bottom = corretto_elated_options()->getOptionValue( 'h4_margin_bottom' );
		
		$item_styles = corretto_elated_get_typography_styles( 'h4' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = corretto_elated_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = corretto_elated_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h4'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_h4_styles' );
}

if ( ! function_exists( 'corretto_elated_h5_styles' ) ) {
	function corretto_elated_h5_styles() {
		$margin_top    = corretto_elated_options()->getOptionValue( 'h5_margin_top' );
		$margin_bottom = corretto_elated_options()->getOptionValue( 'h5_margin_bottom' );
		
		$item_styles = corretto_elated_get_typography_styles( 'h5' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = corretto_elated_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = corretto_elated_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h5'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_h5_styles' );
}

if ( ! function_exists( 'corretto_elated_h6_styles' ) ) {
	function corretto_elated_h6_styles() {
		$margin_top    = corretto_elated_options()->getOptionValue( 'h6_margin_top' );
		$margin_bottom = corretto_elated_options()->getOptionValue( 'h6_margin_bottom' );
		
		$item_styles = corretto_elated_get_typography_styles( 'h6' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = corretto_elated_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = corretto_elated_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h6'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_h6_styles' );
}

if ( ! function_exists( 'corretto_elated_text_styles' ) ) {
	function corretto_elated_text_styles() {
		$item_styles = corretto_elated_get_typography_styles( 'text' );
		
		$item_selector = array(
			'p'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo corretto_elated_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_text_styles' );
}

if ( ! function_exists( 'corretto_elated_link_styles' ) ) {
	function corretto_elated_link_styles() {
		$link_styles      = array();
		$link_color       = corretto_elated_options()->getOptionValue( 'link_color' );
		$link_font_style  = corretto_elated_options()->getOptionValue( 'link_fontstyle' );
		$link_font_weight = corretto_elated_options()->getOptionValue( 'link_fontweight' );
		$link_decoration  = corretto_elated_options()->getOptionValue( 'link_fontdecoration' );
		
		if ( ! empty( $link_color ) ) {
			$link_styles['color'] = $link_color;
		}
		if ( ! empty( $link_font_style ) ) {
			$link_styles['font-style'] = $link_font_style;
		}
		if ( ! empty( $link_font_weight ) ) {
			$link_styles['font-weight'] = $link_font_weight;
		}
		if ( ! empty( $link_decoration ) ) {
			$link_styles['text-decoration'] = $link_decoration;
		}
		
		$link_selector = array(
			'a',
			'p a'
		);
		
		if ( ! empty( $link_styles ) ) {
			echo corretto_elated_dynamic_css( $link_selector, $link_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_link_styles' );
}

if ( ! function_exists( 'corretto_elated_link_hover_styles' ) ) {
	function corretto_elated_link_hover_styles() {
		$link_hover_styles     = array();
		$link_hover_color      = corretto_elated_options()->getOptionValue( 'link_hovercolor' );
		$link_hover_decoration = corretto_elated_options()->getOptionValue( 'link_hover_fontdecoration' );
		
		if ( ! empty( $link_hover_color ) ) {
			$link_hover_styles['color'] = $link_hover_color;
		}
		if ( ! empty( $link_hover_decoration ) ) {
			$link_hover_styles['text-decoration'] = $link_hover_decoration;
		}
		
		$link_hover_selector = array(
			'a:hover',
			'p a:hover'
		);
		
		if ( ! empty( $link_hover_styles ) ) {
			echo corretto_elated_dynamic_css( $link_hover_selector, $link_hover_styles );
		}
		
		$link_heading_hover_styles = array();
		
		if ( ! empty( $link_hover_color ) ) {
			$link_heading_hover_styles['color'] = $link_hover_color;
		}
		
		$link_heading_hover_selector = array(
			'h1 a:hover',
			'h2 a:hover',
			'h3 a:hover',
			'h4 a:hover',
			'h5 a:hover',
			'h6 a:hover'
		);
		
		if ( ! empty( $link_heading_hover_styles ) ) {
			echo corretto_elated_dynamic_css( $link_heading_hover_selector, $link_heading_hover_styles );
		}
	}
	
	add_action( 'corretto_elated_style_dynamic', 'corretto_elated_link_hover_styles' );
}

if ( ! function_exists( 'corretto_elated_smooth_page_transition_styles' ) ) {
	function corretto_elated_smooth_page_transition_styles( $style ) {
		$id            = corretto_elated_get_page_id();
		$loader_style  = array();
		$current_style = '';
		
		$background_color = corretto_elated_get_meta_field_intersect( 'smooth_pt_bgnd_color', $id );
		if ( ! empty( $background_color ) ) {
			$loader_style['background-color'] = $background_color;
		}
		
		$loader_selector = array(
			'.eltdf-smooth-transition-loader'
		);
		
		if ( ! empty( $loader_style ) ) {
			$current_style .= corretto_elated_dynamic_css( $loader_selector, $loader_style );
		}
		
		$spinner_style = array();
		$spinner_color = corretto_elated_get_meta_field_intersect( 'smooth_pt_spinner_color', $id );
		if ( ! empty( $spinner_color ) ) {
			$spinner_style['background-color'] = $spinner_color;
		}
		
		$spinner_selectors = array(
			'.eltdf-st-loader .eltdf-rotate-circles > div',
			'.eltdf-st-loader .pulse',
			'.eltdf-st-loader .double_pulse .double-bounce1',
			'.eltdf-st-loader .double_pulse .double-bounce2',
			'.eltdf-st-loader .cube',
			'.eltdf-st-loader .rotating_cubes .cube1',
			'.eltdf-st-loader .rotating_cubes .cube2',
			'.eltdf-st-loader .stripes > div',
			'.eltdf-st-loader .wave > div',
			'.eltdf-st-loader .two_rotating_circles .dot1',
			'.eltdf-st-loader .two_rotating_circles .dot2',
			'.eltdf-st-loader .five_rotating_circles .container1 > div',
			'.eltdf-st-loader .five_rotating_circles .container2 > div',
			'.eltdf-st-loader .five_rotating_circles .container3 > div',
			'.eltdf-st-loader .atom .ball-1:before',
			'.eltdf-st-loader .atom .ball-2:before',
			'.eltdf-st-loader .atom .ball-3:before',
			'.eltdf-st-loader .atom .ball-4:before',
			'.eltdf-st-loader .clock .ball:before',
			'.eltdf-st-loader .mitosis .ball',
			'.eltdf-st-loader .lines .line1',
			'.eltdf-st-loader .lines .line2',
			'.eltdf-st-loader .lines .line3',
			'.eltdf-st-loader .lines .line4',
			'.eltdf-st-loader .fussion .ball',
			'.eltdf-st-loader .fussion .ball-1',
			'.eltdf-st-loader .fussion .ball-2',
			'.eltdf-st-loader .fussion .ball-3',
			'.eltdf-st-loader .fussion .ball-4',
			'.eltdf-st-loader .wave_circles .ball',
			'.eltdf-st-loader .pulse_circles .ball'
		);
		
		if ( ! empty( $spinner_style ) ) {
			$current_style .= corretto_elated_dynamic_css( $spinner_selectors, $spinner_style );
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'corretto_elated_add_page_custom_style', 'corretto_elated_smooth_page_transition_styles' );
}