<?php
namespace CorrettoRestaurant\CPT\RestaurantMenu;

use CorrettoRestaurant\Lib;

/**
 * Class RestaurantMenuRegister
 * @package CorrettoRestaurant\CPT\RestaurantMenu
 */

class RestaurantMenuRegister implements Lib\PostTypeInterface {
	/**
	 * @var string
	 */
	private $base;
	/**
	 * @var string
	 */
	private $taxBase;

	public function __construct() {
		$this->base    = 'restaurant-menu';
		$this->taxBase = 'restaurant-menu-category';
	}

	/**
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	public function register() {
		$this->registerPostType();
		$this->registerTax();
	}

	/**
	 * Regsiters custom post type with WordPress
	 */
	private function registerPostType() {

		$menuPosition = 5;
		$menuIcon     = 'dashicons-list-view';

		register_post_type($this->base,
			array(
				'labels'        => array(
					'name'          => __('Restaurant Menu', 'corretto-restaurant'),
					'menu_name'     => __('Restaurant Menu', 'corretto-restaurant'),
					'all_items'     => __('Restaurant Menu Items', 'corretto-restaurant'),
					'add_new'       => __('Add New Restaurant Menu Item', 'corretto-restaurant'),
					'singular_name' => __('Restaurant Menu Item', 'corretto-restaurant'),
					'add_item'      => __('New Restaurant Menu Item', 'corretto-restaurant'),
					'add_new_item'  => __('Add New Restaurant Menu Item', 'corretto-restaurant'),
					'edit_item'     => __('Edit Restaurant Menu Item', 'corretto-restaurant')
				),
				'public'        => false,
				'show_in_menu'  => true,
				'menu_position' => $menuPosition,
				'show_ui'       => true,
				'has_archive'   => false,
				'hierarchical'  => false,
				'supports'      => array('title', 'thumbnail'),
				'menu_icon'     => $menuIcon
			)
		);
	}

	/**
	 * Registers custom taxonomy with WordPress
	 */
	private function registerTax() {
		$labels = array(
			'name'              => __('Restaurant Menu Category', 'corretto-restaurant'),
			'singular_name'     => __('Restaurant Menu Category', 'corretto-restaurant'),
			'search_items'      => __('Search Restaurant Menu Categories', 'corretto-restaurant'),
			'all_items'         => __('All Restaurant Menu Categories', 'corretto-restaurant'),
			'parent_item'       => __('Parent Restaurant Menu Category', 'corretto-restaurant'),
			'parent_item_colon' => __('Parent Restaurant Menu Category:', 'corretto-restaurant'),
			'edit_item'         => __('Edit Restaurant Menu Category', 'corretto-restaurant'),
			'update_item'       => __('Update Restaurant Menu Category', 'corretto-restaurant'),
			'add_new_item'      => __('Add New Restaurant Menu Category', 'corretto-restaurant'),
			'new_item_name'     => __('New Restaurant Menu Category Name', 'corretto-restaurant'),
			'menu_name'         => __('Restaurant Menu Categories', 'corretto-restaurant'),
		);

		register_taxonomy($this->taxBase, array($this->base), array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'query_var'         => true,
			'show_admin_column' => true,
		));
	}

}