<?php

if ( ! function_exists( 'corretto_elated_register_woocommerce_dropdown_cart_widget' ) ) {
	/**
	 * Function that register dropdown cart widget
	 */
	function corretto_elated_register_woocommerce_dropdown_cart_widget( $widgets ) {
		$widgets[] = 'CorrettoElatedWooCommerceDropdownCart';
		
		return $widgets;
	}
	
	add_filter( 'corretto_core_register_widgets', 'corretto_elated_register_woocommerce_dropdown_cart_widget' );
}

if ( ! function_exists( 'corretto_elated_get_dropdown_cart_icon_class' ) ) {
	/**
	 * Returns dropdow cart icon class
	 */
	function corretto_elated_get_dropdown_cart_icon_class() {
		$dropdown_cart_icon_source = corretto_elated_options()->getOptionValue( 'dropdown_cart_icon_source' );
		
		$dropdown_cart_icon_class_array = array(
			'eltdf-header-cart'
		);
		
		$dropdown_cart_icon_class_array[] = $dropdown_cart_icon_source == 'icon_pack' ? 'eltdf-header-cart-icon-pack' : 'eltdf-header-cart-svg-path';
		
		return $dropdown_cart_icon_class_array;
	}
}

if ( ! function_exists( 'corretto_elated_get_dropdown_cart_icon_html' ) ) {
	/**
	 * Returns dropdown cart icon HTML
	 */
	function corretto_elated_get_dropdown_cart_icon_html() {
		$dropdown_cart_icon_source   = corretto_elated_options()->getOptionValue( 'dropdown_cart_icon_source' );
		$dropdown_cart_icon_pack     = corretto_elated_options()->getOptionValue( 'dropdown_cart_icon_pack' );
		$dropdown_cart_icon_svg_path = corretto_elated_options()->getOptionValue( 'dropdown_cart_icon_svg_path' );
		
		$dropdown_cart_icon_html = '';
		
		if ( ( $dropdown_cart_icon_source == 'icon_pack' ) && ( isset( $dropdown_cart_icon_pack ) ) ) {
			$dropdown_cart_icon_html .= corretto_elated_icon_collections()->getDropdownCartIcon( $dropdown_cart_icon_pack );
		} else if ( isset( $dropdown_cart_icon_svg_path ) ) {
			$dropdown_cart_icon_html .= $dropdown_cart_icon_svg_path;
		}
		
		return $dropdown_cart_icon_html;
	}
}