<?php

class CorrettoElatedVerticalSeparatorWidget extends CorrettoElatedWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_vertical_separator_widget',
			esc_html__( 'Elated Vertical Separator Widget', 'corretto' ),
			array( 'description' => esc_html__( 'Add a vertical separator element to your widget areas', 'corretto' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Holder Height', 'corretto' ),
				'options' => array(
					'full-height'   => esc_html__( 'Full Height', 'corretto' ),
					'custom-height' => esc_html__( 'Custom Height', 'corretto' ),
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'align',
				'title'   => esc_html__( 'Vertical Align', 'corretto' ),
				'options' => array(
					'middle' => esc_html__( 'Middle', 'corretto' ),
					'top'   => esc_html__( 'Top', 'corretto' ),
					'bottom'  => esc_html__( 'Bottom', 'corretto' )
				)
			),
			array(
				'type'  => 'textfield',
				'name'  => 'height',
				'title' => esc_html__( 'Height (px or %)', 'corretto' ),
				'description' => esc_html__('The percentage applies only if the \'Full Holder Height\' is selected','corretto')
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'corretto' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'corretto' ),
					'dashed' => esc_html__( 'Dashed', 'corretto' ),
					'dotted' => esc_html__( 'Dotted', 'corretto' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'left_margin',
				'title' => esc_html__( 'Left Margin (px)', 'corretto' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'right_margin',
				'title' => esc_html__( 'Right Margin (px)', 'corretto' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}

		$holder_class = '';

		if ($instance['type'] == 'full-height') {
			$holder_class = 'eltdf-vertical-separator-full-height';
		}

		$style = array();

		if ($instance['align'] !== '') {
			$style[] = 'vertical-align:'.$instance['align'];
		}

		if ($instance['height'] !== '') {
			if (corretto_elated_string_ends_with($instance['height'],'%')){
				$height = $instance['height'];
			} else {
				$height = corretto_elated_filter_px($instance['height']).'px';
			}
			$style[] = 'height:'.$height;
		}

		if ($instance['border_style'] !== '') {
			$style[] = 'border-style:'.$instance['border_style'];
		}

		if ($instance['color'] !== '') {
			$style[] = 'border-color:'.$instance['color'];
		}

		if ($instance['thickness'] !== '') {
			$style[] = 'border-width:'.corretto_elated_filter_px($instance['thickness']).'px';
		}

		if ($instance['left_margin'] !== '') {
			$style[] = 'margin-left:'.corretto_elated_filter_px($instance['left_margin']).'px';
		}

		if ($instance['right_margin'] !== '') {
			$style[] = 'margin-right:'.corretto_elated_filter_px($instance['right_margin']).'px';
		}

		$html = '';
		
		$html .= '<div class="widget eltdf-vertical-separator-widget '.esc_attr($holder_class).'">';
		$html .= '<span class="eltdf-vsw-height-holder"></span>';
		$html .= '<span class="eltdf-vsw" '.corretto_elated_get_inline_style($style).'></span>';
		$html .= '</div>';

		echo wp_kses_post($html);
	}
}