<?php

if ( ! function_exists( 'corretto_elated_map_sidebar_meta' ) ) {
	function corretto_elated_map_sidebar_meta() {
		$eltdf_sidebar_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'corretto_elated_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'corretto' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'corretto' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'corretto' ),
				'parent'      => $eltdf_sidebar_meta_box,
                'options'       => corretto_elated_get_custom_sidebars_options( true )
			)
		);
		
		$eltdf_custom_sidebars = corretto_elated_get_custom_sidebars();
		if ( count( $eltdf_custom_sidebars ) > 0 ) {
			corretto_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'corretto' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'corretto' ),
					'parent'      => $eltdf_sidebar_meta_box,
					'options'     => $eltdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_sidebar_meta', 31 );
}