<?php

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_menu_area_meta_boxes' ) ) {
	function corretto_elated_get_hide_dep_for_header_menu_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_menu_area_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_get_hide_dep_for_header_menu_area_widgets_meta_boxes' ) ) {
	function corretto_elated_get_hide_dep_for_header_menu_area_widgets_meta_boxes() {
		$hide_dep_options = apply_filters( 'corretto_elated_header_menu_area_widgets_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'corretto_elated_header_menu_area_meta_options_map' ) ) {
	function corretto_elated_header_menu_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = corretto_elated_get_hide_dep_for_header_menu_area_meta_boxes();
		$hide_dep_widgets = corretto_elated_get_hide_dep_for_header_menu_area_widgets_meta_boxes();
		
		$menu_area_container = corretto_elated_add_admin_container_no_style(
			array(
				'type'       => 'container',
				'name'       => 'menu_area_container',
				'parent'     => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta' => $hide_dep_options
					)
				),
				'args'       => array(
					'enable_panels_for_default_value' => true
				)
			)
		);
		
		corretto_elated_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'corretto' )
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_header_widget_menu_area_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Header Menu Area Widget', 'corretto' ),
				'description'   => esc_html__( 'Enabling this option will hide widget area from the menu area', 'corretto' ),
				'parent'        => $menu_area_container,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta' => $hide_dep_widgets
					)
				)
			)
		);
		
		$corretto_custom_sidebars = corretto_elated_get_custom_sidebars();
		if ( count( $corretto_custom_sidebars ) > 0 ) {
			corretto_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_menu_area_sidebar_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Custom Widget Area In Menu Area', 'corretto' ),
					'description' => esc_html__( 'Choose custom widget area to display in header menu area"', 'corretto' ),
					'parent'      => $menu_area_container,
					'options'     => $corretto_custom_sidebars,
					'dependency' => array(
						'hide' => array(
							'eltdf_header_type_meta' => $hide_dep_widgets
						)
					)
				)
			);
		}
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area In Grid', 'corretto' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'corretto' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_in_grid_meta'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_grid_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'corretto' ),
				'description' => esc_html__( 'Set grid background color for menu area', 'corretto' ),
				'parent'      => $menu_area_in_grid_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_grid_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'corretto' ),
				'description' => esc_html__( 'Set grid background transparency for menu area (0 = fully transparent, 1 = opaque)', 'corretto' ),
				'parent'      => $menu_area_in_grid_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Shadow', 'corretto' ),
				'description'   => esc_html__( 'Set shadow on grid menu area', 'corretto' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Border', 'corretto' ),
				'description'   => esc_html__( 'Set border on grid menu area', 'corretto' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_border_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_border_container',
				'parent'          => $menu_area_in_grid_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_in_grid_border_meta'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_in_grid_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'Set border color for grid area', 'corretto' ),
				'parent'      => $menu_area_in_grid_border_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'Choose a background color for menu area', 'corretto' ),
				'parent'      => $menu_area_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Transparency', 'corretto' ),
				'description' => esc_html__( 'Choose a transparency for the menu area background color (0 = fully transparent, 1 = opaque)', 'corretto' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Shadow', 'corretto' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'corretto' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Border', 'corretto' ),
				'description'   => esc_html__( 'Set border on menu area', 'corretto' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => corretto_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_border_bottom_color_container = corretto_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_border_bottom_color_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_border_meta'  => 'yes'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'Choose color of header bottom border', 'corretto' ),
				'parent'      => $menu_area_border_bottom_color_container
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'eltdf_menu_area_side_padding_meta',
				'label'       => esc_html__( 'Menu Area Side Padding', 'corretto' ),
				'description' => esc_html__( 'Enter value in px or percentage to define menu area side padding', 'corretto' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px or %', 'corretto' )
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'text',
				'name'          => 'eltdf_dropdown_top_position_meta',
				'label'         => esc_html__( 'Dropdown Position', 'corretto' ),
				'description'   => esc_html__( 'Enter value in percentage of entire header height', 'corretto' ),
				'args'          => array(
					'col_width' => 3,
					'suffix'    => '%'
				)
			)
		);
		
		do_action( 'corretto_elated_header_menu_area_additional_meta_boxes_map', $menu_area_container );
	}
	
	add_action( 'corretto_elated_header_menu_area_meta_boxes_map', 'corretto_elated_header_menu_area_meta_options_map', 10, 1 );
}