<?php

if ( ! function_exists( 'corretto_elated_error_404_options_map' ) ) {
	function corretto_elated_error_404_options_map() {
		
		corretto_elated_add_admin_page(
			array(
				'slug'  => '__404_error_page',
				'title' => esc_html__( '404 Error Page', 'corretto' ),
				'icon'  => 'fa fa-exclamation-triangle'
			)
		);
		
		$panel_404_header = corretto_elated_add_admin_panel(
			array(
				'page'  => '__404_error_page',
				'name'  => 'panel_404_header',
				'title' => esc_html__( 'Header', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'      => $panel_404_header,
				'type'        => 'color',
				'name'        => '404_menu_area_background_color_header',
				'label'       => esc_html__( 'Background Color', 'corretto' ),
				'description' => esc_html__( 'Choose a background color for header area', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'text',
				'name'          => '404_menu_area_background_transparency_header',
				'default_value' => '',
				'label'         => esc_html__( 'Background Transparency', 'corretto' ),
				'description'   => esc_html__( 'Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)', 'corretto' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'      => $panel_404_header,
				'type'        => 'color',
				'name'        => '404_menu_area_border_color_header',
				'label'       => esc_html__( 'Border Color', 'corretto' ),
				'description' => esc_html__( 'Choose a border bottom color for header area', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'select',
				'name'          => '404_header_style',
				'default_value' => '',
				'label'         => esc_html__( 'Header Skin', 'corretto' ),
				'description'   => esc_html__( 'Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style', 'corretto' ),
				'options'       => array(
					''             => esc_html__( 'Default', 'corretto' ),
					'light-header' => esc_html__( 'Light', 'corretto' ),
					'dark-header'  => esc_html__( 'Dark', 'corretto' )
				)
			)
		);
		
		$panel_404_options = corretto_elated_add_admin_panel(
			array(
				'page'  => '__404_error_page',
				'name'  => 'panel_404_options',
				'title' => esc_html__( '404 Page Options', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent' => $panel_404_options,
				'type'   => 'color',
				'name'   => '404_page_background_color',
				'label'  => esc_html__( 'Background Color', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_background_image',
				'label'       => esc_html__( 'Background Image', 'corretto' ),
				'description' => esc_html__( 'Choose a background image for 404 page', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_background_pattern_image',
				'label'       => esc_html__( 'Pattern Background Image', 'corretto' ),
				'description' => esc_html__( 'Choose a pattern image for 404 page', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_title_image',
				'label'       => esc_html__( 'Title Image', 'corretto' ),
				'description' => esc_html__( 'Choose a background image for displaying above 404 page Title', 'corretto' )
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_title',
				'default_value' => '',
				'label'         => esc_html__( 'Title', 'corretto' ),
				'description'   => esc_html__( 'Enter title for 404 page. Default label is "404".', 'corretto' )
			)
		);
		
		$first_level_group = corretto_elated_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => 'first_level_group',
				'title'       => esc_html__( 'Title Style', 'corretto' ),
				'description' => esc_html__( 'Define styles for 404 page title', 'corretto' )
			)
		);
		
		$first_level_row1 = corretto_elated_add_admin_row(
			array(
				'parent' => $first_level_group,
				'name'   => 'first_level_row1'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent' => $first_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_title_color',
				'label'  => esc_html__( 'Text Color', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_title_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_title_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_title_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$first_level_row2 = corretto_elated_add_admin_row(
			array(
				'parent' => $first_level_group,
				'name'   => 'first_level_row2',
				'next'   => true
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'corretto' ),
				'options'       => corretto_elated_get_font_style_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'corretto' ),
				'options'       => corretto_elated_get_font_weight_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_title_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'corretto' ),
				'options'       => corretto_elated_get_text_transform_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_subtitle',
				'default_value' => '',
				'label'         => esc_html__( 'Subtitle', 'corretto' ),
				'description'   => esc_html__( 'Enter subtitle for 404 page. Default label is "PAGE NOT FOUND".', 'corretto' )
			)
		);
		
		$second_level_group = corretto_elated_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => 'second_level_group',
				'title'       => esc_html__( 'Subtitle Style', 'corretto' ),
				'description' => esc_html__( 'Define styles for 404 page subtitle', 'corretto' )
			)
		);
		
		$second_level_row1 = corretto_elated_add_admin_row(
			array(
				'parent' => $second_level_group,
				'name'   => 'second_level_row1'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent' => $second_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_subtitle_color',
				'label'  => esc_html__( 'Text Color', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_subtitle_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_subtitle_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_subtitle_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$second_level_row2 = corretto_elated_add_admin_row(
			array(
				'parent' => $second_level_group,
				'name'   => 'second_level_row2',
				'next'   => true
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_subtitle_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'corretto' ),
				'options'       => corretto_elated_get_font_style_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_subtitle_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'corretto' ),
				'options'       => corretto_elated_get_font_weight_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_subtitle_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $second_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_subtitle_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'corretto' ),
				'options'       => corretto_elated_get_text_transform_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_text',
				'default_value' => '',
				'label'         => esc_html__( 'Text', 'corretto' ),
				'description'   => esc_html__( 'Enter text for 404 page.', 'corretto' )
			)
		);
		
		$third_level_group = corretto_elated_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => '$third_level_group',
				'title'       => esc_html__( 'Text Style', 'corretto' ),
				'description' => esc_html__( 'Define styles for 404 page text', 'corretto' )
			)
		);
		
		$third_level_row1 = corretto_elated_add_admin_row(
			array(
				'parent' => $third_level_group,
				'name'   => '$third_level_row1'
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent' => $third_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_text_color',
				'label'  => esc_html__( 'Text Color', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_text_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'corretto' ),
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_text_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_text_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$third_level_row2 = corretto_elated_add_admin_row(
			array(
				'parent' => $third_level_group,
				'name'   => '$third_level_row2',
				'next'   => true
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'corretto' ),
				'options'       => corretto_elated_get_font_style_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'corretto' ),
				'options'       => corretto_elated_get_font_weight_array()
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_text_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'corretto' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		corretto_elated_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'corretto' ),
				'options'       => corretto_elated_get_text_transform_array()
			)
		);

		corretto_elated_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'select',
				'name'          => '404_search_form_skin',
				'default_value' => '',
				'label'         => esc_html__( 'Search Form Skin', 'corretto' ),
				'description'   => esc_html__( 'Choose a style to make search form in that predefined style', 'corretto' ),
				'options'       => array(
					''            => esc_html__( 'Default', 'corretto' ),
					'light-style' => esc_html__( 'Light', 'corretto' )
				)
			)
		);
	}
	
	add_action( 'corretto_elated_options_map', 'corretto_elated_error_404_options_map', 19 );
}