<?php

if ( ! function_exists( 'corretto_elated_map_post_audio_meta' ) ) {
	function corretto_elated_map_post_audio_meta() {
		$audio_post_format_meta_box = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'corretto' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'corretto' ),
				'description'   => esc_html__( 'Choose audio type', 'corretto' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'corretto' ),
					'self'            => esc_html__( 'Self Hosted', 'corretto' )
				)
			)
		);
		
		$eltdf_audio_embedded_container = corretto_elated_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'eltdf_audio_embedded_container'
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'corretto' ),
				'description' => esc_html__( 'Enter audio URL', 'corretto' ),
				'parent'      => $eltdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		corretto_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'corretto' ),
				'description' => esc_html__( 'Enter audio link', 'corretto' ),
				'parent'      => $eltdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_elated_map_post_audio_meta', 23 );
}