<?php

/*** Child Theme Function  ***/

function corretto_elated_child_theme_enqueue_scripts() {
	
	$parent_style = 'corretto_elated_default_style';
	
	wp_enqueue_style('corretto_elated_child_style', get_stylesheet_directory_uri() . '/style.css', array($parent_style));
}

add_action( 'wp_enqueue_scripts', 'corretto_elated_child_theme_enqueue_scripts' );

add_filter( 'wc_product_enable_dimensions_display', '__return_false' );


function woocommerce_template_product_description() {
wc_get_template( 'single-product/tabs/additional-information.php' );
}
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_product_description', 20 );



/**
 * Remove product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );


function woo_remove_product_tabs( $tabs ) {

    unset( $tabs['description'] );      	
    unset( $tabs['reviews'] ); 			
    unset( $tabs['additional_information'] );
    return $tabs;
}

add_action( 'woocommerce_before_cart', 'check_category_in_cart' );
add_action( 'woocommerce_after_cart', 'check_category_in_cart' );

add_action('wp_enqueue_scripts', function(){
	wp_deregister_script( 'wp-mediaelement' );
	wp_deregister_style( 'wp-mediaelement' );
}, PHP_INT_MAX );

 
function check_category_in_cart() {
 
   // Set $cat_in_cart to false
   $cat_in_cart = false;
   $or_ut_cart = true;
   $total = 0;
   $subtotal = 0;
   $promo = 0;
   $promoprice = 0;
	
   // Loop through all products in the Cart
   foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {

      // If Cart has category "download", set $cat_in_cart to true
      if ( has_term( 'coffee-beans', 'product_cat', $cart_item['product_id'] ) ) {
         $cat_in_cart = true;
		 $newsubtotal = $cart_item['data']->get_price() * $cart_item['quantity'];
		 $total = $total + $newsubtotal;
      }
	  if ( has_term( 'toi-moi', 'product_cat', $cart_item['product_id'] ) ) {
         $cat_in_cart = true;
		 $newsubtotal = $cart_item['data']->get_price() * $cart_item['quantity'];
		 $total = $total + $newsubtotal;
      }
	  if ( has_term( 'orang-utan-coffee', 'product_cat', $cart_item['product_id'] ) ) {
		 $cat_in_cart = true;
		 $or_ut_cart = false;
		 $promo = $promo + 1;
		 $newsubtotal = $cart_item['data']->get_price() * $cart_item['quantity'];
		 $promoprice = $newsubtotal;
		 $total = $total + $newsubtotal;
      }
	   
	         // If Cart has category "download", set $cat_in_cart to true
      if ( has_term( 'cafe-en-grains-fr', 'product_cat', $cart_item['product_id'] ) ) {
         $cat_in_cart = true;
		 $newsubtotal = $cart_item['data']->get_price() * $cart_item['quantity'];
		 $total = $total + $newsubtotal;
      }
	  if ( has_term( 'toi-moi-fr', 'product_cat', $cart_item['product_id'] ) ) {
         $cat_in_cart = true;
		 $newsubtotal = $cart_item['data']->get_price() * $cart_item['quantity'];
		 $total = $total + $newsubtotal;
      }
	  if ( has_term( 'orang-utan-fr', 'product_cat', $cart_item['product_id'] ) ) {
		 $cat_in_cart = true;
		 $or_ut_cart = false;
		 $promo = $promo + 1;
		 $newsubtotal = $cart_item['data']->get_price() * $cart_item['quantity'];
		 $promoprice = $newsubtotal;
		 $total = $total + $newsubtotal;
      }    
	   
   }
   if ($promo > 1) {$total = ($total-$promoprice);}
   // Do something if category is in the Cart
   if ( $cat_in_cart && $total>100.00 && $or_ut_cart ) {
       if(ICL_LANGUAGE_CODE == 'en')
	   {
/*	   	  echo'<style>.message{text-align:center;border:2px solid #821616; margin:10px; background:#821616;} .message h6 {color:white;font-family: Consolas; margin:5px;} .message a {text-decoration: underline;}</style><div class="message"><h6><strong>PLEASE REMEMBER TO ADD A BAG OF <a href="https://cafemystiquecoffeeshop.com/product/orang-utan-sumatra-gayo/">ORANG-UTAN COFFEE</a> TO THE CART BEFORE YOU CHECKOUT TO GET IT FREE!</strong></h6></div>';
*/  }
	          if(ICL_LANGUAGE_CODE == 'fr')
	   {
/*	   	  echo'<style>.message{text-align:center;border:2px solid #821616; margin:10px; background:#821616;} .message h6 {color:white;font-family: Consolas; margin:5px;} .message a {text-decoration: underline;}</style><div class="message"><h6><strong>N\'OUBLIEZ PAS D\'AJOUTER UN SAC DE <a href="https://cafemystiquecoffeeshop.com/fr/produit/orang-utan-sumatra-gayo/">CAFÉ ORANG UTAN</a> AU PANIER AVANT DE PASSER À LA CAISSE POUR L\'OBTENIR GRATUITEMENT!</strong></h6></div>';
*/   }
   }
}

