<?php

if ( ! function_exists( 'corretto_core_map_portfolio_meta' ) ) {
	function corretto_core_map_portfolio_meta() {
		global $corretto_elated_Framework;
		
		$eltd_pages = array();
		$pages      = get_pages();
		foreach ( $pages as $page ) {
			$eltd_pages[ $page->ID ] = $page->post_title;
		}
		
		//Portfolio Images
		
		$eltdPortfolioImages = new CorrettoElatedMetaBox( 'portfolio-item', esc_html__( 'Portfolio Images (multiple upload)', 'corretto-core' ), '', '', 'portfolio_images' );
		$corretto_elated_Framework->eltdMetaBoxes->addMetaBox( 'portfolio_images', $eltdPortfolioImages );
		
		$eltdf_portfolio_image_gallery = new CorrettoElatedMultipleImages( 'eltdf-portfolio-image-gallery', esc_html__( 'Portfolio Images', 'corretto-core' ), esc_html__( 'Choose your portfolio images', 'corretto-core' ) );
		$eltdPortfolioImages->addChild( 'eltdf-portfolio-image-gallery', $eltdf_portfolio_image_gallery );
		
		//Portfolio Single Upload Images/Videos 
		
		$eltdf_portfolio_images_videos = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Portfolio Images/Videos (single upload)', 'corretto-core' ),
				'name'  => 'eltdf_portfolio_images_videos'
			)
		);
		corretto_elated_add_repeater_field(
			array(
				'name'        => 'eltdf_portfolio_single_upload',
				'parent'      => $eltdf_portfolio_images_videos,
				'button_text' => esc_html__( 'Add Image/Video', 'corretto-core' ),
				'fields'      => array(
					array(
						'type'        => 'select',
						'name'        => 'file_type',
						'label'       => esc_html__( 'File Type', 'corretto-core' ),
						'options' => array(
							'image' => esc_html__('Image','corretto-core'),
							'video' => esc_html__('Video','corretto-core'),
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'single_image',
						'label'       => esc_html__( 'Image', 'corretto-core' ),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'image'
							)
						)
					),
					array(
						'type'        => 'select',
						'name'        => 'video_type',
						'label'       => esc_html__( 'Video Type', 'corretto-core' ),
						'options'	  => array(
							'youtube' => esc_html__('YouTube', 'corretto-core'),
							'vimeo' => esc_html__('Vimeo', 'corretto-core'),
							'self' => esc_html__('Self Hosted', 'corretto-core'),
						),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'video'
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_id',
						'label'       => esc_html__( 'Video ID', 'corretto-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => array('youtube','vimeo')
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_mp4',
						'label'       => esc_html__( 'Video mp4', 'corretto-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'video_cover_image',
						'label'       => esc_html__( 'Video Cover Image', 'corretto-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					)
				)
			)
		);
		
		//Portfolio Additional Sidebar Items
		
		$eltdAdditionalSidebarItems = corretto_elated_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Additional Portfolio Sidebar Items', 'corretto-core' ),
				'name'  => 'portfolio_properties'
			)
		);

		corretto_elated_add_repeater_field(
			array(
				'name'        => 'eltdf_portfolio_properties',
				'parent'      => $eltdAdditionalSidebarItems,
				'button_text' => esc_html__( 'Add New Item', 'corretto-core' ),
				'fields'      => array(
					array(
						'type'        => 'text',
						'name'        => 'item_title',
						'label'       => esc_html__( 'Item Title', 'corretto-core' ),
					),
					array(
						'type'        => 'text',
						'name'        => 'item_text',
						'label'       => esc_html__( 'Item Text', 'corretto-core' )
					),
					array(
						'type'        => 'text',
						'name'        => 'item_url',
						'label'       => esc_html__( 'Enter Full URL for Item Text Link', 'corretto-core' )
					)
				)
			)
		);
	}
	
	add_action( 'corretto_elated_meta_boxes_map', 'corretto_core_map_portfolio_meta', 40 );
}